/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.entity;

import dev.toma.gunsrpg.ai.RangedAttackNoSightGoal;
import dev.toma.gunsrpg.common.entity.projectile.AbstractProjectile;
import dev.toma.gunsrpg.common.entity.projectile.EffectSpreadReaction;
import dev.toma.gunsrpg.common.entity.projectile.ExplosiveReaction;
import dev.toma.gunsrpg.common.entity.projectile.Grenade;
import dev.toma.gunsrpg.common.entity.projectile.IReaction;
import dev.toma.gunsrpg.common.entity.projectile.MultipartReaction;
import dev.toma.gunsrpg.common.entity.projectile.PropertyTriggerReaction;
import dev.toma.gunsrpg.common.init.ModEntities;
import dev.toma.gunsrpg.common.init.ModItems;
import dev.toma.gunsrpg.common.init.ModSounds;
import dev.toma.gunsrpg.common.item.guns.ammo.AmmoMaterials;
import dev.toma.gunsrpg.util.math.WeightedRandom;
import dev.toma.gunsrpg.util.properties.Properties;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.FleeSunGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RestrictSunGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;

public class ExplosiveSkeletonEntity
extends MonsterEntity
implements IRangedAttackMob,
IEntityAdditionalSpawnData {
    private final RangedAttackNoSightGoal aiArrowAttack = new RangedAttackNoSightGoal(this, 1.0, 25, 18.0f);
    private final MeleeAttackGoal aiAttackOnCollide = new MeleeAttackGoal((CreatureEntity)this, 1.2, false){

        public void func_75251_c() {
            super.func_75251_c();
            ExplosiveSkeletonEntity.this.func_213395_q(false);
        }

        public void func_75249_e() {
            super.func_75249_e();
            ExplosiveSkeletonEntity.this.func_213395_q(true);
        }
    };
    private LoadoutType loadoutType = (LoadoutType)((Object)LoadoutType.access$000().getRandom());

    public ExplosiveSkeletonEntity(World world) {
        this((EntityType<? extends MonsterEntity>)((EntityType)ModEntities.EXPLOSIVE_SKELETON.get()), world);
    }

    public ExplosiveSkeletonEntity(EntityType<? extends MonsterEntity> type, World world) {
        super(type, world);
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233821_d_, 0.25);
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187868_fj, 0.15f, 1.0f);
    }

    public void func_70645_a(DamageSource cause) {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_217385_a((Entity)this, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 3.0f, Explosion.Mode.NONE);
        }
        super.func_70645_a(cause);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.func_179249_a((Enum)this.loadoutType);
    }

    public void readSpawnData(PacketBuffer additionalData) {
        this.loadoutType = (LoadoutType)additionalData.func_179257_a(LoadoutType.class);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223223_b_;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187854_fc;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187864_fh;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187856_fd;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new RestrictSunGoal((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new FleeSunGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new AvoidEntityGoal((CreatureEntity)this, WolfEntity.class, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, true));
    }

    public void func_70636_d() {
        if (this.field_70170_p.func_72935_r() && !this.field_70170_p.field_72995_K) {
            BlockPos blockpos;
            float f = this.func_70013_c();
            BlockPos blockPos = blockpos = this.func_184187_bx() instanceof BoatEntity ? new BlockPos(this.func_226277_ct_(), (double)Math.round(this.func_226278_cu_()), this.func_226281_cx_()).func_177984_a() : new BlockPos(this.func_226277_ct_(), (double)Math.round(this.func_226278_cu_()), this.func_226281_cx_());
            if (f > 0.5f && this.field_70146_Z.nextFloat() * 30.0f < (f - 0.4f) * 2.0f && this.field_70170_p.func_226660_f_(blockpos)) {
                boolean flag = true;
                ItemStack itemstack = this.func_184582_a(EquipmentSlotType.HEAD);
                if (!itemstack.func_190926_b()) {
                    if (itemstack.func_77984_f()) {
                        itemstack.func_196085_b(itemstack.func_77952_i() + this.field_70146_Z.nextInt(2));
                        if (itemstack.func_77952_i() >= itemstack.func_77958_k()) {
                            this.func_213361_c(EquipmentSlotType.HEAD);
                            this.func_184201_a(EquipmentSlotType.HEAD, ItemStack.field_190927_a);
                        }
                    }
                    flag = false;
                }
                if (flag) {
                    this.func_70015_d(8);
                }
            }
        }
        super.func_70636_d();
    }

    public ILivingEntityData func_213386_a(IServerWorld server, DifficultyInstance difficulty, SpawnReason reason, ILivingEntityData livingData, CompoundNBT nbt) {
        super.func_213386_a(server, difficulty, reason, livingData, nbt);
        this.func_180481_a(difficulty);
        this.func_180483_b(difficulty);
        this.setCombatTask();
        this.func_98053_h(this.field_70146_Z.nextFloat() < 0.55f * difficulty.func_180170_c());
        this.field_82174_bp[EquipmentSlotType.MAINHAND.func_188454_b()] = 0.0f;
        this.field_82174_bp[EquipmentSlotType.OFFHAND.func_188454_b()] = 0.0f;
        this.field_184655_bs[EquipmentSlotType.HEAD.func_188454_b()] = 0.0f;
        return livingData;
    }

    public void setCombatTask() {
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            this.field_70714_bg.func_85156_a((Goal)this.aiAttackOnCollide);
            this.field_70714_bg.func_85156_a((Goal)this.aiArrowAttack);
            ItemStack itemstack = this.func_184614_ca();
            if (itemstack.func_77973_b() == ModItems.GRENADE_LAUNCHER) {
                int i = 60;
                if (this.field_70170_p.func_175659_aa() != Difficulty.HARD) {
                    i = 120;
                }
                this.aiArrowAttack.setAttackCooldown(i);
                this.field_70714_bg.func_75776_a(4, (Goal)this.aiArrowAttack);
            } else {
                this.field_70714_bg.func_75776_a(4, (Goal)this.aiAttackOnCollide);
            }
        }
    }

    public void func_70098_U() {
        super.func_70098_U();
        if (this.func_184187_bx() instanceof CreatureEntity) {
            CreatureEntity entitycreature = (CreatureEntity)this.func_184187_bx();
            this.field_70761_aq = entitycreature.field_70761_aq;
        }
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        super.func_180481_a(difficulty);
        this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)ModItems.GRENADE_LAUNCHER));
        ItemStack head = new ItemStack((IItemProvider)Items.field_151024_Q);
        int color = this.loadoutType.getColor();
        CompoundNBT data = new CompoundNBT();
        CompoundNBT display = new CompoundNBT();
        display.func_74768_a("color", color);
        data.func_218657_a("display", (INBT)display);
        head.func_77982_d(data);
        this.func_184201_a(EquipmentSlotType.HEAD, head);
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        Grenade grenade = new Grenade((EntityType<? extends Grenade>)((EntityType)ModEntities.GRENADE_SHELL.get()), this.field_70170_p, (LivingEntity)this);
        IReaction reaction = this.loadoutType.getReaction();
        reaction.writeInitialData(grenade, AmmoMaterials.GRENADE, (LivingEntity)this);
        double x = target.func_226277_ct_() - this.func_226277_ct_();
        double z = target.func_226281_cx_() - this.func_226281_cx_();
        float dist = MathHelper.func_76133_a((double)(x * x + z * z));
        grenade.setup(1.0f, 1.5f, 0);
        grenade.fire(this.field_70125_A - dist * 0.1f, this.field_70177_z, 2.5f);
        grenade.setProperty(Properties.REACTION, reaction);
        this.func_184185_a(ModSounds.GL_SHOT1, 15.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_217376_c((Entity)grenade);
    }

    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74768_a("loadoutType", this.loadoutType.ordinal());
    }

    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.loadoutType = LoadoutType.values()[nbt.func_74762_e("loadoutType")];
        this.setCombatTask();
    }

    public void func_184201_a(EquipmentSlotType slotIn, ItemStack stack) {
        super.func_184201_a(slotIn, stack);
        if (!this.field_70170_p.field_72995_K && slotIn == EquipmentSlotType.MAINHAND) {
            this.setCombatTask();
        }
    }

    public float func_213307_e(Pose p_213307_1_) {
        return 1.74f;
    }

    public double func_70033_W() {
        return -0.6;
    }

    private static class ShockReaction
    implements IReaction {
        private final int range;
        private final int count;

        public ShockReaction(int range, int count) {
            this.range = 1 + range;
            this.count = count;
        }

        @Override
        public void react(AbstractProjectile projectile, Vector3d impact, World world) {
            if (world.field_72995_K) {
                return;
            }
            Random random = world.field_73012_v;
            for (int i = 0; i < this.count; ++i) {
                int x = (int)(impact.field_72450_a + (double)random.nextInt(this.range) - (double)random.nextInt(this.range));
                int z = (int)(impact.field_72449_c + (double)random.nextInt(this.range) - (double)random.nextInt(this.range));
                int y = world.func_201676_a(Heightmap.Type.WORLD_SURFACE, x, z);
                LightningBoltEntity lightning = new LightningBoltEntity(EntityType.field_200728_aG, world);
                lightning.func_70107_b((double)x + 0.5, (double)y, (double)z + 0.5);
                lightning.setDamage(4.0f);
                world.func_217376_c((Entity)lightning);
            }
        }
    }

    private static class BreakBlockReaction
    implements IReaction {
        public static final BreakBlockReaction INSTANCE = new BreakBlockReaction();

        private BreakBlockReaction() {
        }

        @Override
        public void react(AbstractProjectile projectile, Vector3d impact, World world) {
            if (!world.func_82736_K().func_223586_b(GameRules.field_223599_b)) {
                return;
            }
            BlockPos pos = new BlockPos(impact.field_72450_a, impact.field_72448_b, impact.field_72449_c);
            this.destroyBlock(world, pos);
            for (Direction direction : Direction.values()) {
                this.destroyBlock(world, pos.func_177972_a(direction));
            }
        }

        private void destroyBlock(World world, BlockPos pos) {
            BlockState state = world.func_180495_p(pos);
            float speed = state.func_185887_b((IBlockReader)world, pos);
            if (speed < 0.0f || state.func_177230_c().func_149638_a() >= 10000.0f) {
                return;
            }
            world.func_175655_b(pos, false);
        }
    }

    private static enum LoadoutType {
        TEAR_GAS(12, 5360754, new EffectSpreadReaction(5360754, () -> new EffectInstance(Effects.field_76421_d, 100, 1), () -> new EffectInstance(Effects.field_76440_q, 100, 0))),
        STANDARD(35, 12438674, MultipartReaction.multi(BreakBlockReaction.INSTANCE, new ExplosiveReaction(2.0f, Explosion.Mode.DESTROY))),
        IMPACT(8, 13388830, MultipartReaction.multi(BreakBlockReaction.INSTANCE, new ExplosiveReaction(2.0f, Explosion.Mode.DESTROY), new PropertyTriggerReaction<Boolean>(Properties.IMPACT, true))),
        SHOCK(10, 4047564, MultipartReaction.multi(BreakBlockReaction.INSTANCE, new ShockReaction(7, 3), new ExplosiveReaction(2.0f, Explosion.Mode.DESTROY)));

        private static final WeightedRandom<LoadoutType> SELECTOR;
        private final int weight;
        private final int color;
        private final IReaction reaction;

        private LoadoutType(int weight, int color, IReaction reaction) {
            this.weight = weight;
            this.color = color;
            this.reaction = reaction;
        }

        public int getWeight() {
            return this.weight;
        }

        public int getColor() {
            return this.color;
        }

        public IReaction getReaction() {
            return this.reaction;
        }

        static /* synthetic */ WeightedRandom access$000() {
            return SELECTOR;
        }

        static {
            SELECTOR = new WeightedRandom<LoadoutType>(LoadoutType::getWeight, LoadoutType.values());
        }
    }
}

